local textColor = rgbm(0, 0, 0, 1)
local xOffset = 3168
local yOffset = 3897
local displayFont8Seg = "digital display tfb"
local displayFont14Seg = "DSEG14 Classic"

local digitsLeft = {
	vec2(xOffset - 410, yOffset - 53),
	vec2(xOffset - 342, yOffset - 53),
	vec2(xOffset - 272, yOffset - 53),
	vec2(xOffset - 202, yOffset - 53),
}

local dotsLeft = {
	vec2(xOffset - 379, yOffset - 53),
	vec2(xOffset - 309, yOffset - 53),
	vec2(xOffset - 240, yOffset - 53),
}

local digitsRight = {
	vec2(xOffset - 39, yOffset - 53),
	vec2(xOffset + 31, yOffset - 53),
	vec2(xOffset + 101, yOffset - 53),
	vec2(xOffset + 171, yOffset - 53),
}

local dotsRight = {
	vec2(xOffset - 7, yOffset - 53),
	vec2(xOffset + 63, yOffset - 53),
	vec2(xOffset + 133, yOffset - 53),
}

local digitsTop = {
	vec2(xOffset + 88, yOffset - 166),
	vec2(xOffset + 148, yOffset - 166),
	vec2(xOffset + 210, yOffset - 166),
}

local dotsTop = {
	vec2(xOffset + 116, yOffset - 166),
	vec2(xOffset + 177, yOffset - 166),
}

local xPosBottomStart = 512
local digitsBottom = {}

for i = 1, 13 do
	table.insert(digitsBottom, vec2(xOffset - xPosBottomStart + (65 * (i - 1)), yOffset + 47))
end

local dotsBottom = {}

for i = 1, 12 do
	table.insert(dotsBottom, vec2(xOffset - xPosBottomStart + 30 + (65 * (i - 1)), yOffset + 47))
end

local digitsMargin = vec2(200, 200)

local DIGIT_SECTION = function(digitFont, digitPositions, decimalPositions, fontSize, margin, color)
	local digitPositions = digitPositions
	local decimalPositions = decimalPositions
	local digitCount = #digitPositions
	local decimalCount = #decimalPositions
	local fontSize = fontSize
	local margin = margin
	local color = color
	local font = digitFont
	local buffer = "0"

	return function(digitValues, decimal, digitOffset, isTime, isString, clamp)
		ui.pushDWriteFont(font)

		local digitEnd = digitCount
		if clamp then
			digitEnd = clamp
		end

		if not decimal then
			decimal = 0
		end

		if not digitOffset then
			digitOffset = 0
		end

		if #digitValues <= 1 then
			if not digitValues[1] then
				digitValues[1] = 0
			end

			if decimal and decimal > 0 then
				table.insert(digitValues, 1, "0")
			end
		end

		if #digitValues > digitCount then
			decimal = decimal - math.min(#digitValues - digitCount, decimal)

			if isTime then
				ui.setCursor(decimalPositions[1])
				ui.dwriteTextAligned(":", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)
			end
		elseif #digitValues < digitEnd and isTime and not clamp then
			for i = 1, math.min(digitEnd - #digitValues, 2) do
				table.insert(digitValues, 1, buffer)
			end
		end

		if decimal > 0 then
			local offset = math.min(decimalCount - decimal + 1, decimalCount)
			ui.setCursor(decimalPositions[offset])
			ui.dwriteTextAligned(".", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)

			if isTime and clamp and digitCount > 4 then
				ui.setCursor(decimalPositions[offset - 2])

				ui.dwriteTextAligned(".", fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)
			end
		end

		for i = 1, digitEnd do
			if digitValues[i] then
				local offset = digitCount - math.min(#digitValues + digitOffset, digitEnd)
				local text = digitValues[i]

				if not isString then
					text = text % 10
				end

				ui.setCursor(digitPositions[i + offset])
				ui.dwriteTextAligned(text, fontSize, ui.Alignment.Center, ui.Alignment.Center, margin, false, color)
			end
		end

		ui.popDWriteFont()
	end
end

local digitSectionTop = DIGIT_SECTION(displayFont8Seg, digitsTop, dotsTop, 113, digitsMargin, textColor)
local digitSectionLeft = DIGIT_SECTION(displayFont8Seg, digitsLeft, dotsLeft, 128, digitsMargin, textColor)
local digitSectionRight = DIGIT_SECTION(displayFont8Seg, digitsRight, dotsRight, 128, digitsMargin, textColor)
local digitSectionBottom = DIGIT_SECTION(displayFont14Seg, digitsBottom, dotsBottom, 69, vec2(200, 200), textColor)

function drawBottomInfo(text)
	local text = string.pad(text, 13, " ", 1)

	digitSectionBottom(text, 0, 0, false, true)
end

function drawOilPressure(dt, fdata)
	display.text({
		text = "O",
		pos = vec2(xOffset - 228, yOffset - 38),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})
	display.text({
		text = "P",
		pos = vec2(xOffset - 216, yOffset - 38),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local oilPressureAdjusted = math.round(fdata.oilPressure)

	local digits = {}
	local oilPressure = math.clamp(oilPressureAdjusted, 0, 1999)
	while oilPressure > 0 do
		table.insert(digits, 1, math.round(oilPressure % 10))
		oilPressure = math.floor(oilPressure / 10)
	end

	digitSectionLeft(digits, 1)
end

function drawFuelPressure(dt, fdata)
	display.text({
		text = "F",
		pos = vec2(xOffset + 100, yOffset - 38),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})
	display.text({
		text = "P",
		pos = vec2(xOffset + 112, yOffset - 38),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local fuelPressure = math.round(fdata.fuelPressure * 10)

	local digits = {}
	local fuelPressure = math.clamp(fuelPressure, 0, 9999)
	while fuelPressure > 0 do
		table.insert(digits, 1, math.round(fuelPressure % 10))
		fuelPressure = math.floor(fuelPressure / 10)
	end

	digitSectionRight(digits, 1)
end

function drawSpeed(dt, fdata)
	display.text({
		text = "SPEED",
		pos = vec2(xOffset + 178, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local speed = math.round(fdata.speedKmh)

	local digits = {}
	local speed = math.clamp(speed, 0, 9999)
	while speed > 0 do
		table.insert(digits, 1, math.round(speed % 10))
		speed = math.floor(speed / 10)
	end

	digitSectionRight(digits, 0)
end

function drawLap(dt, fdata)
	display.text({
		text = "LAP",
		pos = vec2(xOffset - 300, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local lapCount = fdata.lapCount

	local digits = {}
	local lapCount = math.clamp(lapCount, 0, 999)
	while lapCount > 0 do
		table.insert(digits, 1, math.round(lapCount % 10))
		lapCount = math.floor(lapCount / 10)
	end

	digitSectionLeft(digits, 0, 1)
end

function drawLapTime(dt, fdata)
	display.text({
		text = "LAP",
		pos = vec2(xOffset + 38, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})
	display.text({
		text = "TIME",
		pos = vec2(xOffset + 78, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local lapTimeMs = fdata.lapTimeMs

	local seconds = (lapTimeMs / 1000) % 60 * 100
	local minutes = (lapTimeMs / (1000 * 60)) % 60

	local digits = {}
	local seconds = math.clamp(seconds, 0, 99999)
	while seconds > 0 do
		table.insert(digits, 1, math.round(seconds % 10))
		seconds = math.floor(seconds / 10)
	end

	if minutes > 1 then
		if minutes < 9.999 then
			if #digits <= 4 then
				for _i = 1, 4 - #digits do
					table.insert(digits, 1, 0)
				end
			end
			table.insert(digits, 1, math.floor(minutes))
		else
			for i = 1, 5 do
				digits[i] = 9
			end
		end
	end

	digitSectionRight(digits, 2, 0, true)
end

function drawLastLapTimeBottom(dt, fdata)
	local previousLapTimeMs = car.previousLapTimeMs

	local seconds = (previousLapTimeMs / 1000) % 60 * 100
	local minutes = (previousLapTimeMs / (1000 * 60)) % 60

	local digits = {}
	local seconds = math.clamp(seconds, 0, 99999)
	while seconds > 0 do
		table.insert(digits, 1, math.round(seconds % 10))
		seconds = math.floor(seconds / 10)
	end

	if minutes > 1 then
		if minutes < 9.999 then
			if #digits <= 4 then
				for _i = 1, 4 - #digits do
					table.insert(digits, 1, 0)
				end
			end
			table.insert(digits, 1, math.floor(minutes))
		else
			for i = 1, 5 do
				digits[i] = 9
			end
		end
	end

	digitSectionBottom(digits, 2, 0, true, false, 7)
end

function drawBrakeBias(dt, fdata)
	display.text({
		text = "BRAKE",
		pos = vec2(xOffset - 203, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})
	display.text({
		text = "BIAS",
		pos = vec2(xOffset - 148, yOffset - 18),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local brakeBias = math.round(fdata.brakeBias)

	local digits = {}
	local brakeBias = math.clamp(brakeBias, 0, 999)
	while brakeBias > 0 do
		table.insert(digits, 1, math.round(brakeBias % 10))
		brakeBias = math.floor(brakeBias / 10)
	end

	digitSectionLeft(digits, 1, 0)
end

function drawRpm(dt, fdata)
	display.text({
		text = "RPM",
		pos = vec2(xOffset + 305, yOffset - 68),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local rpm = math.round(fdata.rpm / 100)

	local digits = {}
	local rpm = math.clamp(rpm, 0, 199)
	while rpm > 0 do
		table.insert(digits, 1, math.min(math.round(rpm % 10), 9))
		rpm = math.floor(rpm / 10)
	end

	digitSectionTop(digits, 1, 0)
end

function drawFuel(dt, fdata)
	display.text({
		text = "FUEL",
		pos = vec2(xOffset + 308, yOffset - 50),
		letter = vec2(11, 25),
		font = "vrc-arial-bold",
		width = 100,
		alignment = 0.5,
		color = 0,
	})

	local fuel = math.round(fdata.fuel)

	local digits = {}
	local fuel = math.clamp(fuel, 0, 199)
	while fuel > 0 do
		table.insert(digits, 1, math.round(fuel % 10))
		fuel = math.floor(fuel / 10)
	end

	digitSectionTop(digits, 0, 0)
end

function drawValue(font, string, fontSize, xPos, yPos, xAlign, color, margin)
	ui.pushDWriteFont(font)
	if not margin then
		margin = vec2(350, 350)
	end
	if not color then
		color = rgbm(1, 1, 1, 0.7)
	end
	if not fontSize then
		fontSize = 70
	end

	ui.setCursorX(xPos)
	ui.setCursorY(yPos)
	ui.dwriteTextAligned(string, fontSize, xAlign, ui.Alignment.Center, margin, false, color)
	ui.popDWriteFont()
end

function drawDelta(dt, fdata)
	local isNegative = fdata.performanceMeter < 0

	local performanceMeter = math.round(math.abs(fdata.performanceMeter * 100))

	local digits = {}
	local performanceMeter = math.clamp(performanceMeter, 0, 9999)
	while performanceMeter > 0 do
		table.insert(digits, 1, math.round(performanceMeter % 10))
		performanceMeter = math.floor(performanceMeter / 10)
	end

	if #digits < 3 then
		while #digits < 3 do
			table.insert(digits, 1, "0")
		end
	end

	if isNegative then
		table.insert(digits, 1, "-")
	else
		table.insert(digits, 1, "+")
	end

	digitSectionBottom(digits, 2, 0, false, false, 5)
end

function drawGear(dt, fdata)
	ui.pushDWriteFont(displayFont8Seg)

	ui.setCursorX(xOffset - 171)
	ui.setCursorY(yOffset - 106)
	ui.dwriteTextAligned(fdata.gear, 228, ui.Alignment.End, ui.Alignment.Center, vec2(200, 200), false, textColor)

	ui.popDWriteFont()
end

local rpmLabelPositions = {
	vec2(xOffset - 577, yOffset - 15),
	vec2(xOffset - 541, yOffset - 78),
	vec2(xOffset - 477, yOffset - 134),
	vec2(xOffset - 385, yOffset - 178),
	vec2(xOffset - 278, yOffset - 198),
	vec2(xOffset - 158, yOffset - 200),
	vec2(xOffset - 28, yOffset - 172),
}

function drawRpmLabels()
	ui.pushDWriteFont(displayFont8Seg)

	for i = 1, 7 do
		local rpmLabel = i + 1
		if i == 1 then
			rpmLabel = 0
		end

		ui.setCursor(rpmLabelPositions[i])
		ui.dwriteTextAligned(rpmLabel, 36, ui.Alignment.End, ui.Alignment.Center, vec2(200, 200), false, textColor)
	end

	ui.popDWriteFont()
end
