if car.isAIControlled or car.index ~= 0 then
	return nil
end

local applyLag = math.applyLag
local round = math.round

local sim = ac.getSim()

ac.log("AUDIO")

local ext_car = ac.connect({
	ac.StructItem.key(ac.getCarID(car.index) .. "_ext_car_" .. car.index),
	connected = ac.StructItem.boolean(),
	oilTemperature = ac.StructItem.float(),
	antirollBarFrontPosition = ac.StructItem.int16(),
	antirollBarRearPosition = ac.StructItem.int16(),
	brakeBiasPosition = ac.StructItem.int16(),
	isIgnitionOn = ac.StructItem.boolean(),
	isElectronicsBooted = ac.StructItem.boolean(),
	isStarterCranking = ac.StructItem.boolean(),
	isEngineStarted = ac.StructItem.boolean(),
	isEngineRunning = ac.StructItem.boolean(),
}, true, ac.SharedNamespace.CarScript)

local sfxDirectory = "../../sfx/"
local carID = ac.getCarID(car.index)

if not ac.loadSoundbank(sfxDirectory .. carID .. ".bank", sfxDirectory .. "GUIDs.txt") then
	return
end

local IGNITION_SWITCH = function()
	local lastIgnitionState = ext_car.isIgnitionOn

	local audioEvent = ac.AudioEvent("cars/" .. carID .. "/ign_int", false)
	audioEvent.volume = 1
	audioEvent.pitch = 1
	audioEvent.cameraInteriorMultiplier = 1
	audioEvent.cameraExteriorMultiplier = 1
	audioEvent.cameraTrackMultiplier = 1
	audioEvent:setDistanceMax(2)
	audioEvent:setParam("state", 0)
	return function()
		if sim.isInMainMenu then
			return
		end

		if lastIgnitionState ~= ext_car.isIgnitionOn then
			audioEvent:setParam("state", ext_car.isIgnitionOn and 1 or 0)
			audioEvent:stop()
			audioEvent:start()

			lastIgnitionState = ext_car.isIgnitionOn
		end
	end
end

local TEMPS = function()
	local audioEvent = ac.AudioEvent("cars/" .. carID .. "/temps", false)
	audioEvent.volume = 1
	audioEvent.pitch = 1
	audioEvent.cameraInteriorMultiplier = 1
	audioEvent.cameraExteriorMultiplier = 1
	audioEvent.cameraTrackMultiplier = 1
	audioEvent:setDistanceMax(2)
	audioEvent:setParam("oil", ext_car.oilTemperature)

	local eventTriggered = false
	return function()
		if ext_car.isEngineStarted then
			eventTriggered = false
			if audioEvent:isPlaying() then
				audioEvent:stop()
			end
			return
		end

		audioEvent:setParam("oil", ext_car.oilTemperature)

		if eventTriggered then
			return
		end

		if not audioEvent:isPlaying() then
			audioEvent:start()
			eventTriggered = true
		end
	end
end

local ENGINE = function()
	local engineAudio = 1

	return function(dt)
		if
			not sim.isReplayActive
			and not ext_car.isEngineStarted
			and not ext_car.isStarterCranking
			and round(engineAudio, 2) ~= 0
		then
			engineAudio = applyLag(engineAudio, 0, 0.9, dt)
			ac.CarAudioTweak.setVolume(ac.CarAudioEventID.EngineExt, engineAudio)
			ac.CarAudioTweak.setVolume(ac.CarAudioEventID.EngineInt, engineAudio)
		elseif
			(sim.isReplayActive or ext_car.isEngineStarted or ext_car.isStarterCranking)
			and round(engineAudio, 2) ~= 1
		then
			engineAudio = 1
			ac.CarAudioTweak.setVolume(ac.CarAudioEventID.EngineExt, engineAudio)
			ac.CarAudioTweak.setVolume(ac.CarAudioEventID.EngineInt, engineAudio)
		end
	end
end

local AUDIO = function()
	local ignitionSwitch = IGNITION_SWITCH()
	local temps = TEMPS()
	local engine = ENGINE()
	return function(dt)
		ignitionSwitch()
		temps()
		engine(dt)
	end
end

local audio = AUDIO()

function script.update(dt)
	audio(dt)
end
