-- 4:40 AM 10/18/2024 A
-- Yokai
-- Implementing VTEC as a higher volume pop so I don't have to modify the sound mod
-- Also setting the base volume/pitch here
--

local SIM = ac.getSim()
local CAR --set each cycle to the focused car
local RPM_last = 0

local ext = ac.CarAudioEventID.EngineExt
local int = ac.CarAudioEventID.EngineInt

local base_int = 0.6
local base_ext = 1.5

local base_pitch = 1.03 --I think the original recording is a B18

---

local ready = false
local VTEC = false
local was_VTEC = false
local amplify = 1.70
local rpm_engage = 5500
local rpm_fade = 6500

local mult = 0

function prepare()
	setVolume(base_int, base_ext)

	ac.CarAudioTweak.setPitch(int, base_pitch)
	ac.CarAudioTweak.setPitch(ext, base_pitch)

	ready = true
end

function script.update(dt)

	if (not ready) then
		prepare()
		--if (not ready) then [error] end
	end
	
	CAR = ac.getCar(SIM.focusedCar)

	VTEC = (CAR.rpm > rpm_engage)
	
	--ac.debug("RPM", CAR.rpm)
	--ac.debug("VTEC", VTEC)
	--ac.debug("Volume", math.round(ac.CarAudioTweak.getVolume(ext), 2))

	if (not VTEC and was_VTEC) then
		ac.log("VTEC disengaged "..os.clock())
		setVolume(base_int, base_ext)
		was_VTEC = false
		return -- !!
	end

	if (VTEC) then

		was_VTEC = true

		mult = interpolate(
			rpm_engage, rpm_fade,
			CAR.rpm,
			amplify, 1
		)
	
		setVolume(
			base_int * mult,
			base_ext * mult
		)
	end
end

function setVolume(level_int, level_ext)
	ac.CarAudioTweak.setVolume(int, level_int)
	ac.CarAudioTweak.setVolume(ext, level_ext) 
end

-- (aka range) converts an input between x1 and x2, to an output between y1 and y2
function interpolate(x1, x2,  input,  y1, y2)
    	input = math.clamp(input, x1, x2)
    	return y1 + ((input - x1) / (x2 - x1)) * (y2 - y1)
end