function update(dt)
    display.image {
        image = "assets/aim_mxs.dds",
        pos = vec2(0, 0),
        size = vec2(676, 412)
    }

    -- display.image {
    --     image = "assets/gf.dds",
    --     pos = vec2(400, 4),
    --     size = vec2(71, 94)
    -- }

    --display Gear
    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(192, 73),
        letter = vec2(85, 118),
        font = "ttcup",
        width = 80,
        alignment = 1,
        spacing = 0
    }

    --display RPM
    local rpmText = math.floor(car.rpm)
    local letterText = vec2(55, 88)
    local positionText = vec2(118, 192)
    if car.rpm >= 9999 then
        letterText = vec2(45, 78)
        positionText = vec2(115, 198)
    end
    display.text {
        text = rpmText,
        pos = positionText,
        letter = letterText,
        font = "ttcup",
        width = 230,
        alignment = 0.5,
        spacing = 0,
    }

    --display Speed
    local speedText = math.floor(car.poweredWheelsSpeed)
    display.text {
        text = speedText,
        pos = vec2(139, 270),
        letter = vec2(58, 91),
        font = "ttcup",
        width = 175,
        alignment = 0.5,
        spacing = 0,
    }

    -- laptime gauge
    local time = car.lapTimeMs -- preparation for conversion from ms to minutes, seconds, milliseconds
    local formattedTime =
        string.format(
        "%02d:%02d.%02d",
        math.floor((time / (1000 * 60))) % 60,
        math.floor((time / 1000)) % 60,
        math.floor((time % 1000) / 100)
    )
    display.text {
        text = formattedTime,
        pos = vec2(440, 15),
        letter = vec2(28, 61),
        font = "ttcup",
        width = 46,
        alignment = 1,
        spacing = 0,
    }

    -- Lap Count
    local lapText = car.sessionLapCount
    display.text {
        text = lapText,
        pos = vec2(-5, 15),
        letter = vec2(28, 61),
        font = "ttcup",
        width = 46,
        alignment = 1,
        spacing = 0,
    }

    -- Water Temp
    local waterText = math.floor(car.waterTemperature)
    display.text {
        text = waterText,
        pos = vec2(570, 108),
        letter = vec2(28, 61),
        font = "ttcup",
        width = 46,
        alignment = 1,
        spacing = 0,
    }

    -- Oil Press
    local oilText = string.format("%.1f", car.oilPressure)
    display.text {
        text = oilText,
        pos = vec2(561, 199),
        letter = vec2(28, 61),
        font = "ttcup",
        width = 46,
        alignment = 1,
        spacing = -10,
    }

    -- Battert Voltage
    local ambText = string.format("%.1f", car.batteryVoltage)
    display.text {
        text = ambText,
        pos = vec2(528, 291),
        letter = vec2(28, 61),
        font = "ttcup",
        width = 46,
        alignment = 1,
        spacing = -5,
    }

    -- Info Line
    display.text {
        text = "GPS: GOOD",
        pos = vec2(10, 386),
        letter = vec2(15, 27),
        font = "ttcup",
        color = "0,0,0,1",
        width = 46,
        alignment = 0,
        spacing = -1,
    }
    -- clock
    display.text {
        text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
        pos = vec2(600, 386),
        letter = vec2(15, 27),
        font = "ttcup",
        color = "0,0,0,1",
        width = 46,
        alignment = 0,
        spacing = -1,
    }

end




-- function modeC(dt)
-- 	-- grey background for second screen, draws on top of mesh texture so pay attention to transparency, might need layering depending on what youre doing
--     display.rect {
--         pos = vec2(9, 405),
--         size = vec2(1800, 990),
--         color = rgbm(0.55, 0.55, 0.55, 1)
--     }
--     -- rpm gauge
--     local rpmPercentage = (car.rpm / 8000 * 100) -- conversion to %


--     local amountOfSquares = math.ceil(rpmPercentage/6.25) -- only render the squares the user will actually see, for performance.

--     local color = rgbm(1, 0.8, 0, 1) -- normal colour of the displayed rectangle
--     if Config.ADU2.ShiftWarn < (car.rpm / car.rpmLimiter * 100) then -- if rpms exceed Configured Value colour switches
--         color = rgbm(255, 0, 0, 255)
--     end
--     local rpmPos = vec2(610, 1216)
--     local rpmSize = vec2(200, 200)
--     local rpmPivot = vec2(1028, 1028)

--     for i = 1, amountOfSquares do
--         local thisRotation = (-rpmPercentage) * 2.7 -- "-" turns rotation counter clockwise
--         ui.beginRotation()
--         ui.beginRotation()
--         display.rect {
--             -- draws rectangle
--             pos = rpmPos,
--             size = rpmSize,
--             color = color
--         }
--         ui.endRotation(28)
--         if rpmPercentage > (100 / 16 * i) then
--             thisRotation = -(100 / 16 * i) * 2.7
--         end
--         ui.endPivotRotation(thisRotation + 107, rpmPivot)
--     end