local switches = {
	extraA = 0,
	extraB = 1,
    extraC = 2,
    extraD = 3,
    extraE = 4,
    extraF = 5,
}

local counter = 0
local nitrousDurationSeconds = 100

local armedButton = false
local nitrousActive = false
local volumes= {
	nitrous = 8,
	button = 2,
}

local nitrousPos = vec3(0, 0.816, 0.874)
local buttonPos = vec3(0, 0, 0)

ac.loadSoundbank("sfx/r34.bank", "sfx/GUIDs.txt")
local nitrousEvent = ac.AudioEvent("cars/r34/nitrous_sound", true)
local buttonArmedEvent = ac.AudioEvent("cars/r34/nitrous_armed", false)
local buttonDisarmedEvent = ac.AudioEvent("cars/r34/nitrous_disarmed", false)

nitrousEvent:setPosition(nitrousPos)
buttonArmedEvent:setPosition(buttonPos)
buttonDisarmedEvent:setPosition(buttonPos)

nitrousEvent.volume = ac.getAudioVolume('engine') * volumes.nitrous
buttonArmedEvent.volume = ac.getAudioVolume('engine') * volumes.button
buttonDisarmedEvent.volume = ac.getAudioVolume('engine') * volumes.button

function script.update(dt)
    if car.extraB and not armedButton then
        armedButton = true
    elseif car.extraB and armedButton then
        armedButton = false
    end
    nitrousActive = armedButton and car.extraA and car.speedKmh > 10 and car.gas > 0.1
    setInterval(
        function ()
            ac.setExtraSwitch(switches.extraB, false)
        end, 0.01, "0")
    clearInterval("0")

    ac.store("armedButton", armedButton)
    ac.store("nitrousActive", nitrousActive)
    buttonArmedEvent:resumeIf(car.focusedOnInterior and car.extraB and armedButton)
    buttonDisarmedEvent:resumeIf(car.focusedOnInterior and car.extraB and not armedButton)
    nitrousEvent:resumeIf(car.focusedOnInterior and nitrousActive and counter < nitrousDurationSeconds)
    if nitrousActive and counter < nitrousDurationSeconds then
        counter = counter + dt
    end
    if car.isInPit then
        counter = 0
    end
end