local lambda = 0
local linePsi = 0
local textFont = 'c127'
local showIcon = false
local showIcon1 = false
local nitrousDurationSeconds = 100

local counter = 0

local gears = {
    gearr = {xOffset = 16 , uvStart = vec2((1436-163) / 1600,989 / 1400), uvEnd = vec2(1436 / 1600,1155 / 1400)}, 
    gear0 = {xOffset = 0  , uvStart = vec2((1246-163) / 1600,989 / 1400), uvEnd = vec2(1246 / 1600,1155 / 1400)},
    gear1 = {xOffset = -42, uvStart = vec2(( 180-163) / 1600,989 / 1400), uvEnd = vec2( 180 / 1600,1155 / 1400)},
    gear2 = {xOffset = 0  , uvStart = vec2(( 370-163) / 1600,989 / 1400), uvEnd = vec2( 370 / 1600,1155 / 1400)},
    gear3 = {xOffset = 0  , uvStart = vec2(( 531-159) / 1600,989 / 1400), uvEnd = vec2( 531 / 1600,1155 / 1400)},
    gear4 = {xOffset = 0  , uvStart = vec2(( 699-163) / 1600,989 / 1400), uvEnd = vec2( 699 / 1600,1155 / 1400)},
    gear5 = {xOffset = 0  , uvStart = vec2(( 871-163) / 1600,989 / 1400), uvEnd = vec2( 871 / 1600,1155 / 1400)},
    gear6 = {xOffset = 0  , uvStart = vec2((1070-163) / 1600,989 / 1400), uvEnd = vec2(1070 / 1600,1155 / 1400)},
}

local nitrousCoords = {
    red    = {uvStart = vec2(40  / 1600, 1220 / 1400), uvEnd = vec2(310  / 1600, 1342 / 1400)},
    yellow = {uvStart = vec2(340 / 1600, 1220 / 1400), uvEnd = vec2(610  / 1600, 1342 / 1400)},
    green  = {uvStart = vec2(640 / 1600, 1220 / 1400), uvEnd = vec2(910  / 1600, 1342 / 1400)},
    blue   = {uvStart = vec2(940 / 1600, 1220 / 1400), uvEnd = vec2(1210 / 1600, 1342 / 1400)},
}

function DisplayLambda()
    local floor = 0
    -- mocked lambda values, updates every 1.5s
    setInterval(function()
        if car.gas < 0.05 then
            floor = 14.2
        elseif car.gas < 0.5 then
            floor = 11.8
        else
            floor = 10.8
        end
        lambda = math.floor((floor + math.random() * (floor + 0.5 - floor)) * 10) / 10
    end
    , 1.5, 0)
    clearInterval(0)

    local integer, decimal = math.modf(lambda)

    display.text {
        pos = vec2(1230, 400),
        letter = vec2(225, 250),
        spacing = -80,
        text = string.format("%02d", integer),
        font = textFont,
        color = rgbm.colors.white
    }
    display.text {
        pos = vec2(1570, 400),
        letter = vec2(225, 250),
        spacing = -80,
        text = string.format("%02d", decimal * 100),
        font = textFont,
        color = rgbm.colors.white
    }
    display.text {
        pos = vec2(1420, 360),
        letter = vec2(300, 300),
        text = ".",
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplayCoolant()
    display.text {
        pos = vec2(780, 115),
        letter = vec2(150, 150),
        alignment = 1,
        width = 600,
        spacing = -60,
        text = math.floor(car.waterTemperature),
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplaySpeed()
    display.text {
        pos = vec2(1370, 660),
        letter = vec2(225, 250),
        spacing = -80,
        alignment = 1,
        width = 600,
        text = math.floor(car.speedKmh),
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplayBoost()
    display.text {
        pos = vec2(1670, 150),
        letter = vec2(175, 175),
        spacing = -100,
        text = string.format("%.1f", math.floor(car.turboBoost * 10) / 10),
        font = textFont,
        color = rgbm.colors.white
    }
end

function DrawRPMGauge()
    display.rect({ pos = vec2(530, 470), size = vec2(20, 20), color = rgb(112 / 255, 112 / 255, 112 / 255) })
    local rpmPercentage = (car.rpm * 100) / 8000
    local thisRotation = (-rpmPercentage) * 2.0
    ui.beginRotation()
    display.rect { pos = vec2(538, 480), size = vec2(15, 400), color = rgbm.colors.red }
    ui.endPivotRotation(thisRotation + 92.8, vec2(545, 478))
end

function DisplayLaunch()
    display.text {
        pos = vec2(1080, 920),
        letter = vec2(100, 130),
        spacing = -35,
        text = "5700",
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplayCO2LinePsi()
    local armedButton = ac.load("armedButton")
    local nitrousActive = car.extraA and car.speedKmh > 10 and car.gas > 0.1

    if armedButton == 'true' and nitrousActive then
        setInterval(function()
            linePsi = 9 + math.floor((math.random() * (0 - car.gas)) * 10) / 100
        end
        , 0.5, "0")
        clearInterval("0")
    elseif armedButton == 'true' then
        setInterval(function()
            linePsi = 9 + math.floor((math.random() * (0 - 10)) * 10) / 100
        end
        , 0.5, "0")
        clearInterval("0")
    else
        linePsi = 0
    end
    display.text {
        pos = vec2(1680, 920),
        letter = vec2(100, 130),
        alignment = 1,
        width = 300,
        spacing = -35,
        text = string.format("%.1f", linePsi),
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplayNitrousPsi()
    local armedButton = ac.load("armedButton")
    counter = ac.load("counter")
    local nitrousActive = car.extraA and car.speedKmh > 10 and car.gas > 0.1
    if armedButton == 'true' and nitrousActive and counter ~= nil and math.round(counter) < 10 then
        setInterval(function()
            N2OPsi = 5 + math.floor((math.random() * (0 + car.gas - 5 * car.gas)) * 10) / 100
        end
        , 1, "1")
        clearInterval("1")
    else
        N2OPsi = 0
    end
    display.text {
        pos = vec2(710, 920),
        letter = vec2(100, 130),
        alignment = 1,
        width = 300,
        spacing = -35,
        text = string.format("%.1f", N2OPsi),
        font = textFont,
        color = rgbm.colors.white
    }
end

function DisplayNitrousIcon(color)
    nitrousPos = vec2(850, 550)
    nitrousSize = vec2(270, 122)
    display.image { image = "MOTEC2.png", pos = nitrousPos, size = nitrousSize, uvStart = nitrousCoords[color].uvStart, uvEnd = nitrousCoords[color].uvEnd }
end

function DisplayNitrousLight()
    counter = ac.load("counter")
    isArmed = ac.load("armedButton")
    hasNitrousInBottle = counter ~= nil and math.round(counter) < nitrousDurationSeconds

    if hasNitrousInBottle and isArmed and car.extraA and car.speedKmh > 10 and car.gas > 0.1 then -- active, show blue
        setInterval(function()
            showIcon = not showIcon
        end
        , 0.1 , "2")
        if showIcon then
            DisplayNitrousIcon("blue")
        end 
    elseif hasNitrousInBottle and isArmed then -- armed, show green
        DisplayNitrousIcon("green")
    elseif hasNitrousInBottle and not isArmed then -- not armed, show yellow
        DisplayNitrousIcon("yellow")
    elseif not hasNitrousInBottle then -- empty, show red
        setInterval(function()
            showIcon1 = not showIcon1
        end
        , 1, "3")
        if showIcon1 then
            DisplayNitrousIcon("red")
        end
    end
end

function DisplayGear()
    gearSize = vec2(170, 170)

    if car.gear == -1 then
        display.image { image = "MOTEC2.png", pos = vec2(630 + gears["gearr"].xOffset, 500), size = gearSize, uvStart = gears["gearr"].uvStart, uvEnd = gears["gearr"].uvEnd }
    else
        display.image { image = "MOTEC2.png", pos = vec2(630 + gears["gear" .. car.gear].xOffset, 500), size = gearSize, uvStart = gears["gear" .. car.gear].uvStart, uvEnd = gears["gear" .. car.gear].uvEnd }
    end
end

function DisplayBackgroundImage()
    display.rect({ pos = vec2(0, 0), size = vec2(2044, 1024), color = rgb(23 / 255, 23 / 255, 23 / 255) }) -- just to hide the small red pivot circle (lazy hack)
    display.image { image = "MOTEC2.png", pos = vec2(0, 50), size = vec2(2000, 1425), uvStart = vec2(0, 0), uvEnd = vec2(1, 1) }
end

local color = true
function flashColor(bool)
    if bool then
        return rgbm.colors.yellow
    else
        return rgbm.colors.red
    end
end

function DisplayDangerManifold()
    if (car.engineLifeLeft < 250 or car.rpm > 8500) then
        setInterval(
            function ()
                color = not color
            end, 0.15, "10")

        display.rect({ pos = vec2(462, 250), size = vec2(1120, 500), color = flashColor(color) })
        display.image { image = "warning.png", pos = vec2(462, 200), size = vec2(1120, 600), uvStart = vec2(0,0), uvEnd = vec2(1,1) }

    end
end

function script.update(dt)
    DisplayBackgroundImage()
    DrawRPMGauge()
    DisplayLaunch()
    DisplayLambda()
    DisplayCoolant()
    DisplaySpeed()
    DisplayBoost()
    DisplayCO2LinePsi()
    DisplayNitrousPsi()
    DisplayNitrousLight()
    DisplayGear()
    DisplayDangerManifold()
end
