
Config = {
    ADU1 = {},
    ADU2 = {
        -- config options for ADU2
        ShiftWarn = 80 -- % of RPM (of Limiter) when RPM Bar should turn Red
    }
}

sim = ac.getSim()
SmoothedAccel = {x = 0, z = 0} -- global default value definition for x and z axis of vec() car.acceleration.

function modeA(dt)
    display.rect {
        pos = vec2(0, 1005), 
        size = vec2(1920, 1080),
        color = rgbm(0, 0, 0, 0)
    }
local value = math.saturate
    display.rect {
        color =rgbm(0.5, 0.5, 0.5, 1),
        pos = vec2(0, 0), -- coordinates of top left corner of the texture, pay attention to resolution of that texture
        size = vec2(1920,1080), -- size of the image, "value *" makes it expand towards that maximum value
   }
    -- rainbow rpm gauge
    local value = math.saturate(car.rpm / 6950) -- saturate clamps value between 0 and 1
    display.image {
        image = "assets/RPM_2.dds", -- name of the texture to display
        color = rgbm(0, 0, 1, 1),
        pos = vec2(10,-5), -- coordinates of top left corner of the texture, pay attention to resolution of that texture
        size = vec2(1920 * value, 1080), -- size of the image, "value *" makes it expand towards that maximum value
        uvStart = vec2(0, 0), -- uv coordinate of the top left corner (default is 0, 0)
        uvEnd = vec2(value, 1) -- uv coordinate of the bottom right corner (default is 1, 1), 0- 6950rpms = value, 1 as range for the "uncovering fo the texture"
   }
    -- rainbow rpm gauge
    local value = math.saturate(car.rpm / 7000) -- saturate clamps value between 0 and 1
    display.image {
        image = "assets/RPM_1.dds", -- name of the texture to display
        pos = vec2(0, 0), -- coordinates of top left corner of the texture, pay attention to resolution of that texture
        size = vec2(1920 * value, 1080), -- size of the image, "value *" makes it expand towards that maximum value
        uvStart = vec2(0, 0), -- uv coordinate of the top left corner (default is 0, 0)
        uvEnd = vec2(value, 1) -- uv coordinate of the bottom right corner (default is 1, 1), 0-7000rpms = value, 1 as range for the "uncovering fo the texture"
}
display.image {
        image = "assets/display_1.dds",
        pos = vec2(0, 0), -- coordinates of top left corner
        size = vec2(1920, 1080)
    }
    -- gear display
    local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(230, 60),
        letter = vec2(250, 530),
        font = "e92_big",
        width = 46,
        alignment = 0.5,
        spacing = 0
  }
--Turbo_Dial
        display.text {
	text = string.format("%.1f", car.turboBoost),
        pos = vec2(890, 900),
        letter = vec2(50, 100),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
  }
--Oil_Pressure_Dial
        display.text {
	text = string.format("%.2f", car.oilPressure),
        pos = vec2(450, 900),
        letter = vec2(50, 100),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
  }
--Water_temperature
        display.text {
	text = string.format("%.2f", car.waterTemperature),
        pos = vec2(850, 750),
        letter = vec2(50, 100),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
 }
--Oil Temperature
        display.text {
	text = string.format("%.0f", car.oilTemperature),
        pos = vec2(1510, 870),
        letter = vec2(80, 130),
	font = "e92_big",
	width = 0,
	alignment = 1,
	spacing = 0,
	color = rgbm(1, 0, 0, 1)
  }
--fp1 (Bar)
        display.text {
	text = string.format("%.1f", car.oilPressure),
        pos = vec2(500,750),
        letter = vec2(50, 100),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
  }
--eop1 (Bar)
        display.text {
	text = string.format("%.0f", car.oilPressure),
        pos = vec2(1550,510),
        letter = vec2(80, 130),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
  }
--eot (ºC)
        display.text {
	text = string.format("%.0f", sim.ambientTemperature),
        pos = vec2(1520,690),
        letter = vec2(80, 130),
	font = "e92_big",
	width = 1,
	alignment = 0,
	spacing = 0,
	color = rgbm(1, 1, 1, 1)
        } 
     end

-- display switch
local listOfModes = {modeA, modeB} -- you can add infinite displays, their elements need to be inside function modeN(dt)
local currentMode = tonumber(ac.loadDisplayValue("displayMode", 1))
local lastExtraCState = false

function update(dt)
    ac.debug("Update Delta", dt)
    if car.extraC ~= lastExtraCState then -- switching is bound to extraC key, this tracks the state of extraC
        currentMode = currentMode + 1 -- you start at mode 1 and each extraC press adds +1 to the mode count
        if currentMode > #listOfModes then -- as soon as your mode counter exceeds the number of modes inside listOfModes it defaults back to mode 1
            currentMode = 1 -- should be the same as local currentMode =
        end
        ac.saveDisplayValue("displayMode", currentMode)
    end
    ac.debug("Current Page", currentMode)
    lastExtraCState = car.extraC
    listOfModes[currentMode](dt)
end